<?php
/**
 * Default header builder structure
 *
 * @package xts
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return array(
	'id'      => 'root',
	'type'    => 'root',
	'content' => array(
		0 => array(
			'id'      => 'top-bar',
			'type'    => 'row',
			'content' => array(
				0 => array(
					'id'      => 'column5',
					'type'    => 'column',
					'content' => array(),
				),
				1 => array(
					'id'      => 'column6',
					'type'    => 'column',
					'content' => array(),
				),
				2 => array(
					'id'      => 'column7',
					'type'    => 'column',
					'content' => array(),
				),
				3 => array(
					'id'      => 'column_mobile1',
					'type'    => 'column',
					'content' => array(),
				),
			),
			'params'  => array(
				'flex_layout'            => array(
					'id'    => 'flex_layout',
					'value' => 'stretch-center',
					'type'  => 'selector',
				),
				'height'                 => array(
					'id'    => 'height',
					'value' => 40,
					'type'  => 'slider',
				),
				'mobile_height'          => array(
					'id'    => 'mobile_height',
					'value' => 40,
					'type'  => 'slider',
				),
				'align_dropdowns_bottom' => array(
					'id'    => 'align_dropdowns_bottom',
					'value' => true,
					'type'  => 'switcher',
				),
				'hide_desktop'           => array(
					'id'    => 'hide_desktop',
					'value' => true,
					'type'  => 'switcher',
				),
				'hide_mobile'            => array(
					'id'    => 'hide_mobile',
					'value' => true,
					'type'  => 'switcher',
				),
				'sticky'                 => array(
					'id'    => 'sticky',
					'value' => false,
					'type'  => 'switcher',
				),
				'sticky_height'          => array(
					'id'    => 'sticky_height',
					'value' => 40,
					'type'  => 'slider',
				),
				'color_scheme'           => array(
					'id'    => 'color_scheme',
					'value' => 'light',
					'type'  => 'selector',
				),
				'shadow'                 => array(
					'id'    => 'shadow',
					'value' => false,
					'type'  => 'switcher',
				),
				'background'             => array(
					'id'    => 'background',
					'value' => array(
						'background-color' => array(
							'r' => 4,
							'g' => 66,
							'b' => 111,
							'a' => 1,
						),
					),
					'type'  => 'bg',
				),
				'border'                 => array(
					'id'    => 'border',
					'value' => '',
					'type'  => 'border',
				),
			),
		),
		1 => array(
			'id'      => 'general-header',
			'type'    => 'row',
			'content' => array(
				0 => array(
					'id'      => 'column8',
					'type'    => 'column',
					'content' => array(
						0 => array(
							'id'     => 'fo13u6jg9lhy93a9nttu',
							'type'   => 'logo',
							'params' => array(
								'image'        => array(
									'id'    => 'image',
									'value' => '',
									'type'  => 'image',
								),
								'width'        => array(
									'id'    => 'width',
									'value' => 150,
									'type'  => 'slider',
								),
								'sticky_image' => array(
									'id'    => 'sticky_image',
									'value' => '',
									'type'  => 'image',
								),
								'sticky_width' => array(
									'id'    => 'sticky_width',
									'value' => 150,
									'type'  => 'slider',
								),
								'logo_notice'  => array(
									'id'    => 'logo_notice',
									'value' => '',
									'type'  => 'notice',
								),
							),
						),
						1 => array(
							'id'     => 'q9h8mcr4gk72hupzvoku',
							'type'   => 'space',
							'params' => array(
								'direction' => array(
									'id'    => 'direction',
									'value' => 'h',
									'type'  => 'selector',
								),
								'width'     => array(
									'id'    => 'width',
									'value' => 30,
									'type'  => 'slider',
								),
								'css_class' => array(
									'id'    => 'css_class',
									'value' => '',
									'type'  => 'text',
								),
							),
						),
					),
				),
				1 => array(
					'id'      => 'column9',
					'type'    => 'column',
					'content' => array(
						0 => array(
							'id'     => '0kijrr3s6d58ue4j95ct',
							'type'   => 'mainmenu',
							'params' => array(
								'menu_style'       => array(
									'id'    => 'menu_style',
									'value' => 'underline',
									'type'  => 'selector',
								),
								'menu_full_height' => array(
									'id'    => 'menu_full_height',
									'value' => false,
									'type'  => 'switcher',
								),
								'menu_align'       => array(
									'id'    => 'menu_align',
									'value' => 'left',
									'type'  => 'selector',
								),
								'menu_items_gap'   => array(
									'id'    => 'menu_items_gap',
									'value' => 's',
									'type'  => 'selector',
								),
							),
						),
					),
				),
				2 => array(
					'id'      => 'column10',
					'type'    => 'column',
					'content' => array(
						0 => array(
							'id'     => 'au480tbv8una9vl7zroc',
							'type'   => 'search',
							'params' => array(
								'display'             => array(
									'id'    => 'display',
									'value' => 'form',
									'type'  => 'selector',
								),
								'color_scheme'        => array(
									'id'    => 'color_scheme',
									'value' => 'dark',
									'type'  => 'selector',
								),
								'search_style'        => array(
									'id'    => 'search_style',
									'value' => 'icon-alt',
									'type'  => 'selector',
								),
								'form_color_scheme'   => array(
									'id'    => 'form_color_scheme',
									'value' => 'inherit',
									'type'  => 'selector',
								),
								'categories_dropdown' => array(
									'id'    => 'categories_dropdown',
									'value' => false,
									'type'  => 'switcher',
								),
								'icon_style'          => array(
									'id'    => 'icon_style',
									'value' => 'icon',
									'type'  => 'selector',
								),
								'icon_type'           => array(
									'id'    => 'icon_type',
									'value' => 'default',
									'type'  => 'selector',
								),
								'custom_icon'         => array(
									'id'    => 'custom_icon',
									'value' => '',
									'type'  => 'image',
								),
								'ajax'                => array(
									'id'    => 'ajax',
									'value' => true,
									'type'  => 'switcher',
								),
								'ajax_result_count'   => array(
									'id'    => 'ajax_result_count',
									'value' => 10,
									'type'  => 'slider',
								),
								'post_type'           => array(
									'id'    => 'post_type',
									'value' => 'post',
									'type'  => 'selector',
								),
							),
						),
					),
				),
				3 => array(
					'id'      => 'column_mobile2',
					'type'    => 'column',
					'content' => array(
						0 => array(
							'id'     => '14di6s7djdxmij8hywwa',
							'type'   => 'logo',
							'params' => array(
								'image'        => array(
									'id'    => 'image',
									'value' => '',
									'type'  => 'image',
								),
								'width'        => array(
									'id'    => 'width',
									'value' => 150,
									'type'  => 'slider',
								),
								'sticky_image' => array(
									'id'    => 'sticky_image',
									'value' => '',
									'type'  => 'image',
								),
								'sticky_width' => array(
									'id'    => 'sticky_width',
									'value' => 150,
									'type'  => 'slider',
								),
								'logo_notice'  => array(
									'id'    => 'logo_notice',
									'value' => '',
									'type'  => 'notice',
								),
							),
						),
					),
				),
				4 => array(
					'id'      => 'column_mobile3',
					'type'    => 'column',
					'content' => array(),
				),
				5 => array(
					'id'      => 'column_mobile4',
					'type'    => 'column',
					'content' => array(
						0 => array(
							'id'     => 'us41i2vod9z4vodqp29t',
							'type'   => 'burger',
							'params' => array(
								'style'           => array(
									'id'    => 'style',
									'value' => 'icon',
									'type'  => 'selector',
								),
								'icon_type'       => array(
									'id'    => 'icon_type',
									'value' => 'default',
									'type'  => 'selector',
								),
								'custom_icon'     => array(
									'id'    => 'custom_icon',
									'value' => '',
									'type'  => 'image',
								),
								'position'        => array(
									'id'    => 'position',
									'value' => 'right',
									'type'  => 'selector',
								),
								'color_scheme'    => array(
									'id'    => 'color_scheme',
									'value' => 'inherit',
									'type'  => 'selector',
								),
								'search_form'     => array(
									'id'    => 'search_form',
									'value' => true,
									'type'  => 'switcher',
								),
								'categories_menu' => array(
									'id'    => 'categories_menu',
									'value' => false,
									'type'  => 'switcher',
								),
								'cat_menu_id'     => array(
									'id'    => 'cat_menu_id',
									'value' => 'information',
									'type'  => 'select',
								),
								'tabs_swap'       => array(
									'id'    => 'tabs_swap',
									'value' => false,
									'type'  => 'switcher',
								),
							),
						),
					),
				),
			),
			'params'  => array(
				'flex_layout'            => array(
					'id'    => 'flex_layout',
					'value' => 'stretch-center',
					'type'  => 'selector',
				),
				'height'                 => array(
					'id'    => 'height',
					'value' => 100,
					'type'  => 'slider',
				),
				'mobile_height'          => array(
					'id'    => 'mobile_height',
					'value' => 70,
					'type'  => 'slider',
				),
				'align_dropdowns_bottom' => array(
					'id'    => 'align_dropdowns_bottom',
					'value' => true,
					'type'  => 'switcher',
				),
				'hide_desktop'           => array(
					'id'    => 'hide_desktop',
					'value' => false,
					'type'  => 'switcher',
				),
				'hide_mobile'            => array(
					'id'    => 'hide_mobile',
					'value' => false,
					'type'  => 'switcher',
				),
				'sticky'                 => array(
					'id'    => 'sticky',
					'value' => true,
					'type'  => 'switcher',
				),
				'sticky_height'          => array(
					'id'    => 'sticky_height',
					'value' => 60,
					'type'  => 'slider',
				),
				'color_scheme'           => array(
					'id'    => 'color_scheme',
					'value' => 'dark',
					'type'  => 'selector',
				),
				'shadow'                 => array(
					'id'    => 'shadow',
					'value' => false,
					'type'  => 'switcher',
				),
				'background'             => array(
					'id'    => 'background',
					'value' => array(
						'background-color' => array(
							'r' => 255,
							'g' => 255,
							'b' => 255,
							'a' => 1,
						),
					),
					'type'  => 'bg',
				),
				'border'                 => array(
					'id'    => 'border',
					'value' => '',
					'type'  => 'border',
				),
			),
		),
		2 => array(
			'id'      => 'header-bottom',
			'type'    => 'row',
			'content' => array(
				0 => array(
					'id'      => 'column11',
					'type'    => 'column',
					'content' => array(),
				),
				1 => array(
					'id'      => 'column12',
					'type'    => 'column',
					'content' => array(),
				),
				2 => array(
					'id'      => 'column13',
					'type'    => 'column',
					'content' => array(),
				),
				3 => array(
					'id'      => 'column_mobile5',
					'type'    => 'column',
					'content' => array(),
				),
			),
			'params'  => array(
				'flex_layout'            => array(
					'id'    => 'flex_layout',
					'value' => 'stretch-center',
					'type'  => 'selector',
				),
				'height'                 => array(
					'id'    => 'height',
					'value' => 50,
					'type'  => 'slider',
				),
				'mobile_height'          => array(
					'id'    => 'mobile_height',
					'value' => 50,
					'type'  => 'slider',
				),
				'align_dropdowns_bottom' => array(
					'id'    => 'align_dropdowns_bottom',
					'value' => false,
					'type'  => 'switcher',
				),
				'hide_desktop'           => array(
					'id'    => 'hide_desktop',
					'value' => true,
					'type'  => 'switcher',
				),
				'hide_mobile'            => array(
					'id'    => 'hide_mobile',
					'value' => true,
					'type'  => 'switcher',
				),
				'sticky'                 => array(
					'id'    => 'sticky',
					'value' => false,
					'type'  => 'switcher',
				),
				'sticky_height'          => array(
					'id'    => 'sticky_height',
					'value' => 50,
					'type'  => 'slider',
				),
				'color_scheme'           => array(
					'id'    => 'color_scheme',
					'value' => 'dark',
					'type'  => 'selector',
				),
				'shadow'                 => array(
					'id'    => 'shadow',
					'value' => false,
					'type'  => 'switcher',
				),
				'background'             => array(
					'id'    => 'background',
					'value' => '',
					'type'  => 'bg',
				),
				'border'                 => array(
					'id'    => 'border',
					'value' => '',
					'type'  => 'border',
				),
			),
		),
	),
);
