<?php
/**
 * Default values for theme settings dashboard options.
 *
 * @version 1.0
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return apply_filters(
	'xts_theme_default_values_array',
	array(
		'button_element_shape'       => 'round',
		'page_title_bg'              => array(
			'color'      => '#ff4228',
			'url'        => '',
			'id'         => '',
			'repeat'     => '',
			'size'       => '',
			'attachment' => '',
			'position'   => '',
			'position_x' => '',
			'position_y' => '',
			'css_output' => '1',
		),
		'page_title_color_scheme'    => 'light',
		'page_title_design'          => 'centered',
		'page_title_shop_categories' => '0',
		'page_title_size'            => 'l',
		'blog_spacing'               => '40',
		'blog_columns'               => '1',
		'blog_theme_post_formats'    => '0',
		'blog_excerpt'               => 'full',
		'shop_filters_area'          => '0',
		// Theme settings.
		'alt_typography'             => array(
			0 => array(
				'custom'         => '',
				'google'         => '0',
				'font-family'    => 'iranyekanX',
				'font-weight'    => '700',
				'font-style'     => '',
				'font-subset'    => '',
				'text-transform' => '',
				'line-height'    => '',
				'tablet'         => array(
					'line-height' => '',
				),
				'mobile'         => array(
					'line-height' => '',
				),
			),
		),
		'blog_excerpt_length'        => '135',
		'content_typography'         => array(
			0 => array(
				'custom'         => '',
				'google'         => '0',
				'font-family'    => 'iranyekanX',
				'font-weight'    => '400',
				'font-style'     => '',
				'font-subset'    => '',
				'text-transform' => '',
				'font-size'      => '16',
				'tablet'         => array(
					'font-size'   => '',
					'line-height' => '',
				),
				'mobile'         => array(
					'font-size'   => '',
					'line-height' => '',
				),
				'line-height'    => '',
				'color'          => '#777777',
			),
		),
		'copyrights_layout'          => 'centered',
		'entities_typography'        => array(
			0 => array(
				'custom'         => '',
				'google'         => '0',
				'font-family'    => 'iranyekanX',
				'font-weight'    => '700',
				'font-style'     => '',
				'font-subset'    => '',
				'text-transform' => '',
				'line-height'    => '',
				'tablet'         => array(
					'line-height' => '',
				),
				'mobile'         => array(
					'line-height' => '',
				),
				'color'          => '#04426f',
				'hover'          => array(
					'color' => '#ff4228',
				),
			),
		),
		'footer_color_scheme'        => 'default',
		'header_typography'          => array(
			0 => array(
				'custom'         => '',
				'google'         => '0',
				'font-family'    => 'iranyekanX',
				'font-weight'    => '500',
				'font-style'     => '',
				'font-subset'    => '',
				'text-transform' => '',
				'font-size'      => '15',
				'tablet'         => array(
					'font-size'   => '',
					'line-height' => '',
				),
				'mobile'         => array(
					'font-size'   => '',
					'line-height' => '',
				),
				'line-height'    => '',
				'color'          => '#04426f',
				'hover'          => array(
					'color' => '#093656',
				),
				'active'         => array(
					'color' => '#04426f',
				),
			),
		),
		'links_color'                => array(
			'idle'       => '#ff4228',
			'hover'      => '#db0d0d',
			'css_output' => '1',
		),
		'primary_color'              => array(
			'idle'       => '#ff4228',
			'css_output' => '1',
		),
		'secondary_color'            => array(
			'idle'       => '#04426f',
			'css_output' => '1',
		),
		'title_typography'           => array(
			0 => array(
				'custom'         => '',
				'google'         => '0',
				'font-family'    => 'iranyekanX',
				'font-weight'    => '700',
				'font-style'     => '',
				'font-subset'    => '',
				'text-transform' => '',
				'line-height'    => '',
				'tablet'         => array(
					'line-height' => '',
				),
				'mobile'         => array(
					'line-height' => '',
				),
				'color'          => '#04426f',
			),
		),
	)
);
